local PANEL = {};

// link to class
function PANEL:LinkToClass( cls )
	self.LinkedClass = cls;
	
end

// button.
function PANEL:Init( )
	// linked to
	self.LinkedClass = nil;
	
	// vals
	self.Checked = false;
	
	// create label
	self.Label = vgui.Create( "label", self );
	self.Label:SetMouseInputEnabled( false );
	
	// create icon
	self.Icon = vgui.Create( "ctl_icon", self );
	self.Icon:SetMaterial( AppFramework:Theme().icons['close_button'] );
	self.Icon:SetMouseInputEnabled( false );
	self.Icon:SetVisible( false );
	
end

// set checked
function PANEL:SetChecked( v )
	// store value.
	self.Checked = v;
	
	// update icon
	self.Icon:SetVisible( self.Checked );
	
end

// get checked
function PANEL:GetChecked( )
	return self.Checked;

end

// set text
function PANEL:SetText( v )
	self.Label:SetText( v );
	
end

// scheme
function PANEL:ApplySchemeSettings( )
	// set label fonts
	self.Label:SetFont( AppFramework:Theme().fonts['text'] );
	self.Label:SetFGColor( AppFramework:Theme().colors['text'] );
	
end

// perform layout
function PANEL:PerformLayout( )
	// size text
	self.Label:SizeToContents();
	self.Label:SetPos(
		20,
		9 - self.Label:GetTall() * 0.5
	);
	
	// position icon
	self.Icon:SetPos( 1, 1 );
	self.Icon:SetSize( 16, 16 );
	
	// set my size
	self:SetSize(
		self.Label:GetWide() + 24,
		18
	);
	
end

// do click to toggle
function PANEL:OnMouseReleased( )
	// toggle.
	self:SetChecked( !self:GetChecked() );
	
	// run check changed
	if( self.LinkedClass ) then
		self.LinkedClass:CallEvent( "OnValueChanged", self:GetChecked() );
		
	end
	
end

// draw
function PANEL:Paint( )
	// draw frame.
	AppFramework:Theme():DrawFrame( 0, 0, 18, 18, FRAME_INSET );
	
	//
	return true;
	
end

// register
vgui.Register( "ctl_checkbox", PANEL, "Panel" );



// create app framework control.
CtlCheckBox_class 	= Control_class:create( nil, false, "ctl_checkbox" );

// set value
function CtlCheckBox_class:SetChecked( v )
	self:GetHandle():SetChecked( v );
	
end

// get value
function CtlCheckBox_class:GetChecked( )
	return self:GetHandle():GetChecked();
	
end

// set smoothbar
function CtlCheckBox_class:SetText( v )
	self:GetHandle():SetText( v );
	
end
